'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung © 2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Public Sub Vollbildansicht()
    ' Umschaltung zwischen Normal- und Vollbild-Ansicht
    If Application.DisplayFullScreen = True Then
        Application.DisplayFullScreen = False
    Else
        Application.DisplayFullScreen = True
    End If
End Sub


Public Sub Druckvorschau()
    ' Hinweis zum Schließen bei Vollbildansicht
    If Application.DisplayFullScreen = True Then
        MsgBox "Beenden der Druckvorschau mit [Esc] möglich.", vbInformation + vbOKOnly, "Hinweis"
    End If
    ' Druckvorschau einschalten
    Application.ActiveSheet.PrintPreview
End Sub


Public Sub FilterKoppeln()
    ' ------------------------------------------------------------------
    ' Aktiviert/Deaktiviert die Synchronität der Filter der
    ' beiden Pivot-Tabellen
    '
    ' Autor: Jens Wawrczeck
    '
    ' Letzte Änderung: 2018-08-05
    ' ------------------------------------------------------------------
    
    
    ' Fehlerbehandlung einschalten
    On Error GoTo Err_FilterKoppeln
    
    ' Excel-Versions-Prüfung (falls älter als Excel-2010 [=14])
    If Round(Val(Application.Version)) < 14 Then
        MsgBox "Diese Funktion wird erst ab Excel 2010 unterstützt." & vbNewLine, vbInformation + vbOKOnly, "Hinweis"
    Else
        Call FilterJetztKoppeln
    End If

    ' Programmende
Exit_FilterKoppeln:
    Exit Sub
    
    ' Fehlerbehandlung
Err_FilterKoppeln:
    MsgBox "Während der Programmausführung ist ein Fehler aufgetreten!" & vbNewLine & vbNewLine & _
        "Bitte kontaktieren Sie den Programmierer per E-Mail an [info@jens-wawrczeck.de].", _
        vbExclamation + vbOKOnly, "Warnung"
    Resume Exit_FilterKoppeln
    
End Sub

Private Sub FilterJetztKoppeln()
    
    ' Fehlerbehandlung einschalten
    On Error GoTo Err_FilterJetztKoppeln
    
    ' Deklaration der Variablen
    Dim Scs As SlicerCache
    
    ' Bildschirmflackern verhindern
    Application.ScreenUpdating = False
    
    ' Prüfen, wieviele Pivot-Tabellen zugeordnet sind
    If ActiveWorkbook.SlicerCaches.Item(1).PivotTables.Count = 1 Then
        ' 2. Tabelle aktivieren
        For Each Scs In ActiveWorkbook.SlicerCaches
            Scs.PivotTables.AddPivotTable (ActiveSheet.PivotTables("ptDetails"))
        Next
        MsgBox "Die Filter der Tabellen wurden ge-koppelt.", vbInformation + vbOKOnly, "Kopplung"
    Else
        ' 2. Tabelle de-aktivieren
        For Each Scs In ActiveWorkbook.SlicerCaches
            Scs.PivotTables.RemovePivotTable ("ptDetails")
        Next
        MsgBox "Die Filter der Tabellen wurden ent-koppelt.", vbInformation + vbOKOnly, "Entkopplung"
    End If
    
    ' Bildschirmaktualisierung wieder ein
    Application.ScreenUpdating = True
    
    
    ' Programmende
Exit_FilterJetztKoppeln:
    Exit Sub
    
    ' Fehlerbehandlung
Err_FilterJetztKoppeln:
    MsgBox "Während der Programmausführung ist ein Fehler aufgetreten!" & vbNewLine & vbNewLine & _
        "Bitte kontaktieren Sie den Programmierer per E-Mail an [info@jens-wawrczeck.de].", _
        vbExclamation + vbOKOnly, "Warnung"
    Resume Exit_FilterJetztKoppeln
    
End Sub


Public Sub PivotFilterAusschalten()
    ' ------------------------------------------------------------------
    ' Löscht alle ausgewählten Filter der Pivot-Tabellen
    ' des _aktiven_ Arbeitsblattes
    '
    ' Autor: Jens Wawrczeck
    '
    ' Letzte Änderung: 2018-03-20
    ' ------------------------------------------------------------------


    ' Deklaration der Variablen
    Dim PivTbl As PivotTable
    
    ' Fehlerbehandlung einschalten
    On Error GoTo Err_FilterAusschalten
    
    ' Alle Pivot-Filter (des aktiven Blattes) entfernen
    For Each PivTbl In ActiveSheet.PivotTables
        PivTbl.ClearAllFilters
    Next
    
    
    ' Programmende
Exit_Button_FilterAusschalten:
    Exit Sub
    
    ' Fehlerbehandlung
Err_FilterAusschalten:
    MsgBox "Während der Programmausführung ist ein Fehler aufgetreten!" & vbNewLine & vbNewLine & _
        "Bitte kontaktieren Sie den Programmierer per E-Mail an [info@jens-wawrczeck.de].", _
        vbExclamation + vbOKOnly, "Warnung"
    Resume Exit_Button_FilterAusschalten
    
End Sub


Public Sub TermineDatenSuchen()
    ' ------------------------------------------------------------------
    ' Auswahl einer Access-Datenbank-Datei über den Datei-Öffnen-Dialog
    ' und Anpassung des Pfads der Datenbankabfrage
    '
    ' Autor: Jens Wawrczeck
    '
    ' Letzte Änderung: 2018-12-10               (OHNE Fehlerbehandlung!)
    ' ------------------------------------------------------------------
    
    
    ' Dimensionierung der Variablen
    Dim varDatei As Variant                 ' Datei bzw. FALSE bei Abbruch
    Dim strFilter As String                 ' Voreingestellter Dateifilter
    Dim Verbindung As Variant
    Dim x As Integer
    Dim PivTbl As PivotTable
    Dim wks As Worksheet
    
    
    
    ' Aktuelle Excel-Version anzeigen
    ActiveSheet.Range("D3").Value = Round(Val(Application.Version))
    
    ' Setzen des Dateifilters
    strFilter = "Access-2007 (*.accdb),*.accdb,Access-2000 (*.mdb),*.mdb"
    
    ' Aufruf des Datei-Öffnen-Dialogs und Übernahme des gewählten Dateinamens
    varDatei = Application.GetOpenFilename(strFilter)
    
    ' evtuellen Dialogabbruch bearbeiten
    If varDatei = False Then
        MsgBox "Die Dateiauswahl wurde vom Benutzer abgebrochen.", vbInformation, "Abbruch"
        Exit Sub
    End If
    
    ' Aktuelle TerminDaten-Datei anzeigen
    ActiveSheet.Range("D4").Value = varDatei
    
    ' Bildschirmflackern verhindern
    Application.ScreenUpdating = False
    
    ' Aktualisierung der Verbindungsdefinition
    For Each Verbindung In ActiveWorkbook.Connections
        With Verbindung.OLEDBConnection
            .BackgroundQuery = True
            '.CommandText = Array("Kalender")
            .CommandType = xlCmdTable
            .Connection = Array( _
            "OLEDB;Provider=Microsoft.ACE.OLEDB.12.0;Password="""";User ID=Admin;Data Source=" & varDatei & ";Mode=Share Deny Write;Extended Properties="""";" _
            , "Jet OLEDB:System database="""";Jet OLEDB:Registry Path="""";Jet OLEDB:Database Password="""";Jet OLEDB:Engine Type=6;" _
            , "Jet OLEDB:Database Locking Mode=0;Jet OLEDB:Global Partial Bulk Ops=2;Jet OLEDB:Global Bulk Transactions=1;Jet OLEDB:New Database Password="""";" _
            , "Jet OLEDB:Create System Database=False;Jet OLEDB:Encrypt Database=False;Jet OLEDB:Don't Copy Locale on Compact=False;" _
            , "Jet OLEDB:Compact Without Replica Repair=False;Jet OLEDB:SFP=False;Jet OLEDB:Support Complex Data=False")
            .RefreshOnFileOpen = False
            .SavePassword = False
            .SourceConnectionFile = ""
            .SourceDataFile = varDatei
            .ServerCredentialsMethod = xlCredentialsMethodIntegrated
            .AlwaysUseConnectionFile = False
            '.ServerFillColor = False
            '.ServerFontStyle = False
            '.ServerNumberFormat = False
            '.ServerTextColor = False
        End With
    Next
    
    ' ALLE Pivot-Filter zurücksetzten
    For x = 1 To Sheets.Count
        For Each PivTbl In Sheets(x).PivotTables
            PivTbl.ClearAllFilters
        Next PivTbl
    Next x
    
    ' Bildschirmaktualisierung wieder ein
    Application.ScreenUpdating = True
    
    ' Erstes Tabellenblatt in den Focus holen
    Sheets(1).Select
    
    ' Änderungen speichern
    ActiveWorkbook.Save
    
    ' Erfolgsmeldung
    MsgBox "Die Verbindung zur Access-Datei wurde erfolgreich hergestellt." & vbNewLine & vbNewLine & _
        "Bitte betätigen Sie nun im Menü:" & vbNewLine & "Daten | Alle aktualisieren" & _
        vbNewLine & "(evtl. 2x !)", vbInformation, "Fertig"
    
End Sub
